

from django.contrib import admin


class LastUpdateAdmin(admin.ModelAdmin):
    """
    Настройки показа LastUpdate в админке
    """

    # поля, показываемые в списке страниц
    list_display = (
        'update_type',
        'type',
        'updated_at',
    )
    list_per_page = 10


class GroupMembershipAdmin(admin.ModelAdmin):
    """
    Настройки показа GroupMembership в админке
    """

    # поля, показываемые в списке страниц
    list_display = (
        'id',
        'staff',
        'group',
        'joined_at',
    )
    # по кому искать из поисковой строки
    search_fields = (
        '=id',
        '=staff__id',
        '=staff__login',  # по логину ищем как ILIKE
        '=staff__uid',
        '=group__id',
        'group__name',
    )

    list_per_page = 40
    # иерархический фильтр по датам в шапке
    date_hierarchy = 'joined_at'
