
from django.contrib import admin


class NotificationAdmin(admin.ModelAdmin):
    """
    Настройки показа модели Notification в админке
    """

    # поля, показываемые в списке страниц
    list_display = (
        'id',
        'message',
        'url',
        'is_active',
    )
    list_per_page = 10

    # по клику на каких полях переходить на редактирование страницы
    list_display_links = (
        'id',
        'message',
    )

    # readonly поля на форме редактирования
    readonly_fields = ('id',)

    # поля, исключенные из формы редактирования
    exclude = ('disabled_for_users',)
