from enum import Enum


MDS_STORAGE_FIELD = 'mds_storage_id'
S3_STORAGE_FIELD = 's3_key'


class ReservedSupertagAction(Enum):
    CREATE = 'create'
    DELETE = 'delete'


class PageOrderPosition(str, Enum):
    BEFORE = 'before'
    AFTER = 'after'


class ReservedError(Exception):
    pass


class ReservedCreationError(ReservedError):
    pass


class ReservedDeletionError(ReservedError):
    pass
