
from wiki.pages.models import ActualityMark, ActualityMarkLink, ActualityMarkExternalLink


def get_actuality_mark(page_id):
    """
    Возвращает ActualityMark по id страницы.
    Если не найдётся, вернёт None.

    @type page_id: basestring|int
    @rtype: ActualityMark
    """
    try:
        return ActualityMark.objects.get(page=page_id)
    except ActualityMark.DoesNotExist:
        return None


def get_linked_actual_pages_supertags(page_id):
    """
    Возвращает список супертэгов актуальных страниц из всех ActualityMarkLink с указанным id страницы.
    Если таких не найдётся, будет пустой список.

    @type page_id: basestring|int
    """
    return ActualityMarkLink.objects.filter(page=page_id).values_list('actual_page__supertag', flat=True)


def get_linked_actual_pages_tags(page_id):
    """
    Возвращает список тэгов актуальных страниц из всех ActualityMarkLink с указанным id страницы.
    Если таких не найдётся, будет пустой список.

    @type page_id: basestring|int
    """
    return ActualityMarkLink.objects.filter(page=page_id).values_list('actual_page__tag', flat=True)


def get_actuality_mark_links(page_id):
    """
    Возвращает список всех ActualityMarkLink по id страницы.
    Если ничего таких не найдётся, будет пустой список.

    @type page_id: basestring|int
    """
    return ActualityMarkLink.objects.filter(page=page_id)


def get_actuality_mark_external_links(page_id):
    """
    Возвращает список всех ActualityMarkExternalLink по id страницы.
    Если ничего таких не найдётся, будет пустой список.

    @type page_id: basestring|int
    """
    return ActualityMarkExternalLink.objects.filter(page=page_id)


def get_actual_external_link_urls(page_id):
    """
    Возвращает список всех внешних ссылок для страницы

    @type page_id: basestring|int
    """
    return ActualityMarkExternalLink.objects.filter(page=page_id).values_list('url', flat=True)


def remove_actuality_mark_links_to(page):
    """
    Удалить все ActualityMarkLink, ссылающиеся на page как более актуальную.

    @type page: Page
    """
    ActualityMarkLink.objects.filter(actual_page=page).delete()
