

import logging

from wiki.pages.models import Page
from wiki.files.models import File
from wiki.org import get_org

logger = logging.getLogger(__name__)


def decrement_files_count(page):
    """
    Уменьшить денормализованное поле — число прикрепленных к странице файлов
    """
    try:
        page.files = max(0, page.files - 1)
    except Page.DoesNotExist:
        logging.exception('Page does not exist')
    else:
        page.save()


def increment_files_count(page):
    """
    Увеличить денормализованное поле — число прикрепленных к странице файлов
    """
    try:
        page.files += 1
    except Page.DoesNotExist:
        logging.exception('Page does not exist')
    else:
        page.save()


def get_files(page, **kwargs):
    return File.active.filter(page_id=page.id, **kwargs)


def get_user_css_for_intranet(page):
    supertags_chain = page.get_supertags_chain(include_self=True)

    files = File.active.filter(
        page__supertag__in=supertags_chain,
        page__org=get_org(),
        url='user.css',
    ).values_list('page__supertag', 'url')
    if files:
        page_supertag = files[0][0]
        file_url = files[0][1]
        return File.full_path('/' + page_supertag, file_url)
