
from wiki.org import get_org
from wiki.pages.models import Page
from wiki.utils.supertag import tag_to_supertag


def get_page_by_supertag(supertag, include_inactive=False):
    """
    Возвращает Page по супертэгу.
    Если не найдётся, возвращает None.
    Если include_inactive=True — ищем среди удаленных и неудаленных.

    @type supertag: basestring
    @type include_inactive: bool
    @rtype: Page
    """
    model_manager = Page.active
    if include_inactive:
        model_manager = Page.objects

    try:
        return model_manager.get(supertag=supertag, org=get_org())
    except Page.DoesNotExist:
        return None


def get_pages_by_supertags(supertags):
    """
    Возвращает итератор по инстансам Page, чьи супертэги даны на вход.
    Если страница не найдётся, её не будет в возвращаемом списке. Результат не упорядочен.

    @type supertags: iterable
    @rtype: iterable
    """
    return Page.objects.filter(supertag__in=supertags, org=get_org())


def page_exists(tag):
    """
    Вернуть True, если страница существует.

    @rtype: bool
    """
    return Page.active.filter(supertag=tag_to_supertag(tag), org=get_org()).exists()
