from wiki.api_v2.public.pages.schemas import AclPreviewSchema, AclSchema, GroupSchema
from wiki.api_v2.public.utils.get_object import get_page_or_none
from wiki.pages.access import get_bulk_raw_access, interpret_raw_access
from wiki.pages.access.utils import get_legacy_acl
from wiki.pages.models import Page
from wiki.pages.models.consts import AclType
from wiki.sync.connect.base_organization import BaseOrganization
from wiki.users.user_data_repository import USER_DATA_REPOSITORY


def get_acl_preview(page: Page) -> AclPreviewSchema:
    raw_access = get_bulk_raw_access([page])[page]
    access = interpret_raw_access(raw_access)
    acl_type = AclType.DEFAULT

    if access['is_restricted']:
        acl_type = AclType.CUSTOM

    if access['is_owner']:
        acl_type = AclType.ONLY_AUTHORS

    inherits = raw_access['list'] and raw_access['latest_supertag'] != raw_access['supertag']
    inherits_from = raw_access['latest_supertag'] if inherits else None

    return AclPreviewSchema(type=acl_type, inherits_from=inherits_from, is_readonly=page.is_readonly)


def get_acl_schema(page: Page, organization: BaseOrganization, force_inheritance: bool = False) -> AclSchema:
    acl = get_legacy_acl(page, force_inheritance)
    inherits_from = None

    if acl.inherits_from:
        inherits_from = get_page_or_none(organization, supertag=acl.inherits_from)

    return AclSchema(
        acl_type=acl.acl_type,
        break_inheritance=acl.break_inheritance,
        inherits_from=inherits_from,
        is_readonly=page.is_readonly,
        users=[USER_DATA_REPOSITORY.orm_to_user_schema(u) for u in acl.users],
        groups=[GroupSchema.serialize(s) for s in acl.groups],
    )
