from wiki.org import org_ctx, get_org
from wiki.pages.models import Page
from wiki.sync.connect.base_organization import BaseOrganization


def _fetch_supertag(page_or_supertag):
    if isinstance(page_or_supertag, Page):
        return page_or_supertag.supertag
    else:
        return page_or_supertag


def get_supertags_chain(page_or_supertag, include_self=False):
    """
    Вернуть список супертегов родителей в т.ч. виртуальных, которых в базе нет.

    Родители упорядочены от корня к supertag.
    """
    chain = []
    supertag = _fetch_supertag(page_or_supertag)

    parents = supertag.split('/')[:-1]
    if parents:
        for index in range(1, len(parents) + 1):
            chain.append('/'.join(parents[:index]))

    if include_self:
        chain.append(supertag)

    return chain


def get_parent(page_or_supertag):
    """
    Мамонтенок ищет маму
    """
    supertag = _fetch_supertag(page_or_supertag)

    if '/' not in supertag:
        return None

    possible_parent, tail = supertag.rsplit('/', 1)

    try:
        org = page_or_supertag.org if isinstance(page_or_supertag, Page) else get_org()
        with org_ctx(org):
            return Page.active.get(supertag=possible_parent, org=get_org())
    except Page.DoesNotExist:
        return


def get_nearest_existing_parent(page_or_supertag, organization: BaseOrganization = None):
    """
    Найти ближайшего родителя; @todo - переписать на parent
    """
    possible_parents_supertags = get_supertags_chain(page_or_supertag)

    if organization:
        qs = organization.get_active_pages()
        return qs.filter(supertag__in=possible_parents_supertags).order_by('supertag').last()
    else:
        org = page_or_supertag.org if isinstance(page_or_supertag, Page) else get_org()
        with org_ctx(org):
            return Page.active.filter(supertag__in=possible_parents_supertags, org=org).order_by('supertag').last()
