
import chardet

from wiki.pages.logic.import_file.import_errors import ImportException


def to_wiki_text(file_object, page, user):
    content = file_object.read()

    # Пробуем угадать кодировку
    detect_result = chardet.detect(content)
    if detect_result and 'encoding' in detect_result:
        encoding = detect_result['encoding']
    else:
        raise ImportException("Can't determine file encoding")

    if encoding is None:
        return content

    try:
        content = content.decode(encoding)
    except UnicodeError:
        raise ImportException("Can't decode file content")

    return content
