
from wiki.utils import timezone
from wiki.notifications import logic as notifications_logic


def update_keywords(page, user, keywords):
    """
    @type keywords: list of strings (str or unicode)
    """
    if page.keywords_list == keywords:
        return

    page.keywords_list = keywords
    page.modified_at_for_index = timezone.now()
    page.save()

    notifications_logic.create_page_event_keywords(page=page, user=user)
