from wiki.api_v2.public.pages.schemas import OfficialitySchema
from wiki.pages.models import Page
from wiki.users.user_data_repository import USER_DATA_REPOSITORY


def get_officiality(page: Page) -> OfficialitySchema:
    a = OfficialitySchema(
        is_official=page.is_official,
    )
    if hasattr(page, 'officiality') and page.officiality is not None:
        a.responsible_persons = [
            USER_DATA_REPOSITORY.orm_to_user_schema(r) for r in page.officiality.responsible_persons
        ]
        # a.responsible_groups = [USER_DATA_REPOSITORY.orm_to_user_schema(r) for r in page.officiality.responsible_persons]
    return a
