from wiki.notifications import logic as notify_logic
from wiki.utils import timezone


def set_redirect(page, user, destination):
    page.redirects_to = destination
    page.redirect_target()  # Здесь может вылететь RedirectLoopException
    page.modified_at_for_index = timezone.now()
    page.save()

    notify_logic.create_page_event_change_to_redirect(
        page=page,
        user=user,
        destination=destination,
    )


def remove_redirect(page, user):
    page.redirects_to = None
    page.modified_at_for_index = timezone.now()
    page.save()

    notify_logic.create_page_event_revert_from_redirect(page=page, user=user)
