
from wiki.pages.models import Access
from wiki.utils.staff import get_staff_group_repo


def get_group_responsibles_for_page(page):
    """
    Возвращает список ответственных в группах которые имеют доступ к данной странице

    :param page:
    :type page: Page
    :return:
    """
    access_qs = Access.objects.filter(page=page).exclude(group_id=None)

    repo = get_staff_group_repo()
    group_ids = [str(g.group_id) for g in access_qs]
    if len(group_ids) == 0:
        return set()

    group_ids_txt = ','.join(group_ids)
    result_set = repo.getiter({'id': group_ids_txt, '_fields': 'id,responsibles.person.id', '_limit': 100})

    people_ids = set()

    for page in result_set.get_pages():
        for record in page.result:
            for responsible in record['responsibles']:
                people_ids.add(responsible['person']['id'])

    return people_ids
