

from urllib.parse import urlencode

from django.conf import settings

from wiki.utils.supertag import translit


def url_to_wiki_page_in_frontend(page, query_args=None, action=None, restore_if_deleted=False):
    """
    Урл до вики-страницы на фронтэнде.

    @type page: Page
    @param query_args: либо список из пар либо словарь
    @type action: basestring
    @rtype: unicode
    """
    supertag = page.supertag
    if restore_if_deleted and page.status == 0:
        supertag = page.supertag_before_deletion

    return '{protocol}://{host}/{page}/{handler}{query}'.format(
        protocol=settings.WIKI_PROTOCOL,
        host=settings.NGINX_HOST,
        page=supertag,
        handler=('.' + action) if action else '',
        # Не используйте urlencode с doseq=True в этом месте, т.к. будут неправильно закодированы unicode строки
        query=('?' + urlencode(query_args)) if query_args else '',
    )


def tag_to_page_url(tag):
    """
    Вернуть path без query до вики-страницы (строится как траслит тэга без потери регистра).
    """
    # TODO: wiki_translit с параметром to_lower не обвязана тестами и неверно работает с
    # TODO: users/dezzan/СборкапартнерскогодистрибутиваПунты.
    return '/' + translit(tag, to_lower=False)
