def format_comment(comment):
    """
    Функция на данный момент используется в единственном месте
    "форматировании" комментария актуальности страницы, фронт ожидает
    от бека отфоматированный bemjson. Не можем себе позволить иметь
    форматер на беке ради одной этой функциональности, функция генерит
    фейковый bemjson, в котором на самом деле неотфоматированный текст
    можно будет удалить, когда фронт переедет на api/v2
    """
    data = comment.body
    if data is None:
        data = ''

    fake_bemjson = {
        'block': 'wiki-doc',
        'wiki-attrs': {},
    }

    content = []
    offset = 0
    for line in data.split('\n'):
        if offset > 0:
            content.append({
                'block': 'wiki-br',
                'wiki-attrs': {
                    'pos_start': offset,
                    'pos_end': offset + 1,
                },
            })
            offset += 1

        content.append({
            'block': 'wiki-txt',
            'wiki-attrs': {
                'txt': line,
                'pos_start': offset,
                'pos_end': offset + len(line),
            },
        })
        offset += len(line)

    fake_bemjson['content'] = content
    return fake_bemjson
