
from django.conf import settings
from django.contrib.auth import get_user_model
from django.core.management.base import BaseCommand
from django.db import transaction
from django.db.models import ObjectDoesNotExist

from wiki.pages.models import Page, Revision

User = get_user_model()


class Command(BaseCommand):
    help = 'Set owner and last author to any page without an author'

    def handle(self, *args, **options):
        update_counter = update()
        print('updated {0} pages'.format(update_counter))


def some_user():
    # Какой-то подходящий пользователь.
    if settings.IS_INTRANET:
        return User.objects.get(username='puroman')
    else:
        return User.objects.get(username='shadart-r')


def get_user(page):
    revision = Revision.objects.filter(page=page).exclude(author=None).order_by('-created_at').first()
    if revision:
        try:
            return revision.author
        except ObjectDoesNotExist:
            return some_user()
    else:
        return some_user()


@transaction.atomic
def update():
    counter = 0
    for page in Page.objects.filter(owner=None):
        page.owner = get_user(page)
        page.save()
        page.authors.add(get_user(page))
        counter += 1
    for page in Page.objects.filter(last_author=None):
        page.last_author = get_user(page)
        page.save()
        counter += 1
    return counter
