
from django.core.management.base import BaseCommand
from django.db.models import Count, Min
from wiki.legacy.plocker import PLocker

from wiki.pages.models import PageWatch


class Command(BaseCommand, PLocker):
    help = 'Clean up page watches (many watches the same page)'

    def handle(self, *args, **options):

        qs = (
            PageWatch.objects.values('user', 'tag')
            .annotate(num_watches=Count('user'), min_time=Min('time'))
            .filter(num_watches__gt=1)
            .order_by('tag')
        )
        qs.query.group_by = ['user', 'tag']
        for dublah in qs:
            killah = PageWatch.objects.filter(user=dublah['user']).filter(tag=dublah['tag']).order_by('-time')
            s_killah = len(killah)
            for i in range(s_killah):
                if i < s_killah - 1:
                    PageWatch.objects.get(id=killah[i].id).delete()
