
import logging

from django.contrib.auth import get_user_model
from django.core.management.base import BaseCommand, CommandError
from django.db import DatabaseError
from wiki.intranet.models import Staff


class NeedArgumentsError(CommandError):
    pass


class CantCreateUserError(CommandError):
    pass


class CantFindStaffError(CommandError):
    pass


class Command(BaseCommand):
    help = 'Create Django user'

    def add_arguments(self, parser):
        super(Command, self).add_arguments(parser)
        parser.add_argument('info', nargs=3, help='<username email staff_id>')

    def handle(self, *args, **options):
        logging.info('Creating django user: {0!r}'.format(options))
        try:
            username, email, staff_id = options['info']
        except ValueError:
            logging.exception('Couldnt parse args')
            raise NeedArgumentsError('provide username, email and staff_id in command line')
        try:
            django_user = get_user_model().objects.create(
                username=username, email=email, is_staff=False, is_active=True, is_superuser=False
            )
        except DatabaseError as db_error:
            logging.exception('Couldnt create django user {0}'.format(username))
            raise CantCreateUserError('can\'t create user: {0}'.format(db_error))
        try:
            staff = Staff.objects.get(id=staff_id)
        except Staff.DoesNotExist:
            logging.exception('Couldnt find staff id={0}'.format(staff_id))
            raise CantFindStaffError('can\'t find staff with id={0}'.format(staff_id))
        else:
            staff.user = django_user
            staff.save()
        logging.info('Created ok: {0}'.format(django_user))
        print(1)
