
import logging

from django.contrib.auth import get_user_model
from django.core.management.base import BaseCommand

from wiki.pages.models import Page
from wiki.personalisation.user_cluster import create_personal_page
from wiki.utils.supertag import translit


class Command(BaseCommand):
    help = 'Create personal page for those users who don\'t have it'

    def add_arguments(self, parser):
        super(Command, self).add_arguments(parser)
        parser.add_argument('usernames', nargs='*', help='Usernames')

    def handle(self, *args, **options):
        users = self.parse_args(options['usernames'])
        for user in users:
            personal_supertag = translit('users/' + user.username)
            already_exists = Page.objects.filter(supertag=personal_supertag).exists()
            if not already_exists:
                try:
                    page = create_personal_page(user)
                except Exception as exc:
                    logging.exception('Could not create cluster for "%s", because: "%s"', user, repr(exc))
                else:
                    print('Created', page.supertag)

    def parse_args(self, args):
        if len(args) > 0:
            return get_user_model().objects.filter(username__in=args)
        else:
            return get_user_model().objects.all()
