
from django.core.management.base import BaseCommand
from django.contrib.auth import get_user_model

from wiki.legacy.plocker import PLocker

from wiki.pages.access import get_bulk_access_status, ACCESS_DENIED
from wiki.pages.models import PageWatch


class Command(BaseCommand, PLocker):
    help = 'Kill subscriptions which users have no rights to have'

    def handle(self, **options):
        if self.is_slave():
            return
        users = get_user_model().objects.all()
        watches_to_delete = []
        for user in users.iterator():
            his_subscriptions = PageWatch.objects.select_related('page').filter(user=user.username)
            if his_subscriptions.count() == 0:
                continue
            pages = set([])
            for watch in his_subscriptions:
                pages.add(watch.page.supertag)
            for supertag, status in get_bulk_access_status(pages, user).items():
                if status == ACCESS_DENIED:
                    for watch in his_subscriptions:
                        if watch.page.supertag == supertag:
                            watches_to_delete.append(watch.id)

        PageWatch.objects.filter(id__in=watches_to_delete).delete()
