
from django.core.management.base import BaseCommand, CommandError

from wiki.pages.reserved_supertags import is_reserved_supertag


class NeedSupertagError(CommandError):
    pass


class Command(BaseCommand):
    help = 'Print 1 if provided supertag is reserved, otherwise print 0'

    def add_arguments(self, parser):
        super(Command, self).add_arguments(parser)
        parser.add_argument('supertag', nargs=1, help='Supertag to check')

    def handle(self, *args, **options):
        try:
            supertag = options['supertag'][0]
        except IndexError:
            raise NeedSupertagError('provide supertag')
        if is_reserved_supertag(supertag):
            print('1')
        else:
            print('0')
