
from django.core.management.base import BaseCommand

from wiki.pages.cluster import Cluster
from wiki.utils import timezone


class Command(BaseCommand):
    help = 'move cluster from place to place https://wiki.yandex-team.ru/wackowiki/dev/django/handlers/move/'

    def add_arguments(self, parser):
        super(Command, self).add_arguments(parser)
        parser.add_argument('-f', '--from', dest='source', action='store', help='source cluster')
        parser.add_argument('-t', '--to', dest='destination', action='store', help='destination of cluster')
        parser.add_argument(
            '-u', '--user', dest='username', action='store', default='chapson', help='What user is moving cluster'
        )

    def handle(self, *args, **options):
        c = Cluster(options.get('username'))
        source = options.get('source').strip('/')
        destination = options.get('destination').strip('/')
        start = timezone.now()
        r = c.move({source: destination})
        print('it took', (timezone.now() - start).seconds, 'seconds')
        print(r)
