from django.core.management.base import BaseCommand

from wiki.pages.handlers.remove import remove_page
from wiki.pages.models import Page
from wiki.utils.supertag import translit


class Command(BaseCommand):
    help = 'Remove cluster, specified by tag or supertag'

    def add_arguments(self, parser):
        super(Command, self).add_arguments(parser)
        parser.add_argument('-c', '--cluster', dest='cluster', action='store', help='cluster to delete')
        parser.add_argument(
            '-r', '--recursive', dest='recursive', action='store_true', default=False, help='delete with subpages'
        )
        parser.add_argument(
            '-p', '--permanently', dest='permanent', action='store_true', default=False, help='Delete PERMANENTLY'
        )

    def handle(self, *args, **options):
        if options.get('permanent'):
            if input(prompt='Really delete permanently? This operation cannot be undone [y/N]') not in ('y', 'Y'):
                print('Cancelled by user')
                return
        if not options.get('cluster'):
            raise Exception('You must supply a cluster tag')
        page = Page.objects.get(supertag=translit(options.get('cluster')))
        deleted_ids = remove_page(page, recursive=options.get('recursive'), permanently=options.get('permanent'))
        if options.get('verbosity') > 0:
            print('Deleted', len(deleted_ids), 'pages')
            if options.get('verbosity') > 1:
                if options.get('permanent'):
                    print(deleted_ids)
                else:
                    print([_.supertag for _ in Page.objects.filter(id__in=deleted_ids).order_by('-created_at')])
