

from django.core.management.base import BaseCommand
from django.db import transaction

from wiki.pages.models import Revision, Page


def create_revision(page):
    Revision.objects.create_from_page(page)


def pages_that_miss_revisions():
    for page_id in Page.objects.all().values_list('id', flat=True):
        if Revision.objects.filter(page_id=page_id).exists():
            continue
        yield Page.objects.get(id=page_id)


def restore_missing_revisions():
    transaction.set_autocommit(False)
    for page in pages_that_miss_revisions():
        print('creating revision for "{0}"'.format(page.supertag))
        create_revision(page)
        transaction.commit()


class Command(BaseCommand):
    help = 'Restore missing revisions'

    def handle(self, *args, **options):
        restore_missing_revisions()
