
from django.core.management.base import BaseCommand


class Command(BaseCommand):
    help = 'Fix PageWatch user field'

    def handle(self, *args, **options):
        import re
        from wiki.pages.models import PageWatch

        broken_watches = PageWatch.objects.filter(user__contains='(')
        for watch in broken_watches:
            print('\n', watch.id, watch)
            regex = r'^.+\((?P<username>.+)\)$'
            username = re.match(regex, watch.user).groupdict()['username']
            print(username)
            if PageWatch.objects.filter(page=watch.page, user=username).exists():
                print('deleting watch', watch)
                watch.delete()
            else:
                print('updating watch')
                watch.user = username
                watch.save()
