import logging

from django.core.management.base import BaseCommand

from wiki.grids.models import Grid
from wiki.pages.logic.backlinks import track_links
from wiki.pages.models import Page

log = logging.getLogger('wiki.management_commands')


class Command(BaseCommand):
    help = 'Fix TrackLinks records for all pages in intranet'

    def add_arguments(self, parser):
        super(Command, self).add_arguments(parser)
        parser.add_argument('--id', type=int, default=0, dest='from_id', help='start processing from page id')

    @staticmethod
    def fix_track_links(page_id, is_grid):
        try:
            page = Grid.objects.get(id=page_id) if is_grid else Page.objects.get(id=page_id)
            track_links(page, False)
        except Exception:
            log.exception("Can't handle links on page with id=%s" % page_id)

    def handle(self, *args, **options):
        log.info('Start of processing...')

        from_id = options.get('from_id')
        page_ids = Page.active.filter(id__gt=from_id).values_list('id', 'page_type').order_by('id')

        i = 0
        for page_id, page_type in page_ids:
            if i % 100 == 0:
                log.info('Processing page with id=%s' % page_id)
            self.fix_track_links(page_id, page_type == Page.TYPES.GRID)
            i += 1

        log.info('End of processing.')
