"""
Удаляем дублирующиеся объекты модели Access из базы
"""
import logging

from django.core.management.base import BaseCommand
from django.db.transaction import atomic

from wiki.pages.models import Access
from wiki.utils.timer import track_time

logger = logging.getLogger('management_commands')


@track_time
@atomic
def run_command():
    all_group_access = Access.objects.filter(group_id__isnull=False).values_list('id', 'group_id', 'page_id')

    entries = {}
    for id, group_id, page_id in all_group_access:
        orig_id = entries.setdefault((group_id, page_id), id)

        if id != orig_id:
            Access.objects.get(pk=id).delete()
            logger.info('removed duplicate access obj id=%d', id)


class Command(BaseCommand):
    help = 'Remove duplicate Access objects'

    def handle(self, *args, **options):
        run_command()
