
from django.core.management.base import BaseCommand

from wiki.pages.models import PageRename
from wiki.utils.models import queryset_iterator


class Command(BaseCommand):
    """
    Исправить тег и супертег для всех страниц из PageRename
    """

    def handle(self, *args, **options):
        renames = PageRename.objects.select_related('page')

        for rename in queryset_iterator(renames):
            page = rename.page

            fixed_tag = rename.new_tag
            fixed_supertag = rename.new_supertag

            if page.tag == fixed_tag and page.supertag == fixed_supertag:
                continue

            page.tag, page.supertag = fixed_tag, fixed_supertag
            print(page.tag, page.supertag)
            page.save()
