from multiprocessing import cpu_count

from django.core.management import BaseCommand

from wiki.pages.models import Comment
from wiki.pages.utils.comments import strip_comments_from_html
from wiki.utils.base_command import command_logger

MAX_THREADS = cpu_count()


class Command(BaseCommand):
    help = 'Strip all comments from html tags.'

    def add_arguments(self, parser):
        super(Command, self).add_arguments(parser)
        parser.add_argument(
            '--threads', type=int, default=MAX_THREADS, dest='threads', help='number of threads to spawn'
        )

    def handle(self, *args, **options):
        threads = options.get('threads')

        # get comment ids to work with
        comments = Comment.objects.all().values_list('id', flat=True)

        # process comments
        strip_comments_from_html(comments, threads=threads, logger=command_logger)
