
from django.core.management.base import BaseCommand

from wiki.pages.models import Page
from wiki.utils.supertag import translit


class Command(BaseCommand):
    help = 'Tests Uri translit on existing wikipages'

    def handle(self, *args, **options):
        wrong = 0
        wrongpairs = []

        for page in Page.objects.all():
            if page.supertag != translit(page.tag):
                wrong += 1
                wrongpairs.append(page.tag)
                wrongpairs.append(page.supertag)

        print('Wrong count: ' + str(wrong))

        if wrong > 0:
            f = open('wrong.txt', 'w')
            length = len(wrongpairs)
            i = 0
            while i < length:
                f.write(
                    (wrongpairs[i] + ' => ' + wrongpairs[i + 1] + ' :: ' + translit(wrongpairs[i]) + '\n').encode(
                        'utf-8'
                    )
                )
                i += 2
            f.close()

        print('Done')
