# Generated by Django 1.10 on 2016-08-23 14:48
# flake8: noqa

import datetime

import django.utils.timezone
import django_mds.storage
import model_utils.fields
from django.conf import settings
from django.db import migrations, models
from django.utils.timezone import utc

import wiki.utils.timezone


class Migration(migrations.Migration):
    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name='AbsentPage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('to_supertag', models.CharField(db_index=True, max_length=250)),
                ('to_tag', models.CharField(default=b'', max_length=250)),
            ],
        ),
        migrations.CreateModel(
            name='Access',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_common', models.BooleanField(default=False)),
                ('is_owner', models.BooleanField(default=False)),
                ('is_anonymous', models.BooleanField(default=False)),
            ],
        ),
        migrations.CreateModel(
            name='AccessRequest',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('reason', models.TextField()),
                ('verdict', models.NullBooleanField()),
                ('verdict_reason', models.TextField(null=True)),
            ],
        ),
        migrations.CreateModel(
            name='ActualityMark',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
            options={
                'verbose_name': '\u043e\u0442\u043c\u0435\u0442\u043a\u0430 \u043e\u0431 \u0430\u043a\u0442\u0443\u0430\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u0441\u0442\u0440\u0430\u043d\u0438\u0446',
                'verbose_name_plural': '\u043e\u0442\u043c\u0435\u0442\u043a\u0438 \u043e\u0431 \u0430\u043a\u0442\u0443\u0430\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u0441\u0442\u0440\u0430\u043d\u0438\u0446',
            },
        ),
        migrations.CreateModel(
            name='ActualityMarkLink',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
            options={
                'verbose_name': '\u0441\u0441\u044b\u043b\u043a\u0430 \u043d\u0430 \u0431\u043e\u043b\u0435\u0435 \u0430\u043a\u0442\u0443\u0430\u043b\u044c\u043d\u0443\u044e \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0443',
                'verbose_name_plural': '\u0441\u0441\u044b\u043b\u043a\u0438 \u043d\u0430 \u0431\u043e\u043b\u0435\u0435 \u0430\u043a\u0442\u0443\u0430\u043b\u044c\u043d\u044b\u0435 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b',
            },
        ),
        migrations.CreateModel(
            name='Comment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('body', models.TextField()),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('page_at', models.DateTimeField()),
                ('status', models.BooleanField(default=True)),
            ],
            options={
                'db_table': 'wakka_comments',
            },
        ),
        migrations.CreateModel(
            name='Page',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                (
                    'mds_storage_id',
                    models.FileField(
                        max_length=200,
                        null=True,
                        storage=django_mds.storage.MDSStorage(),
                        upload_to=wiki.pages.models.page.upload_to,
                    ),
                ),
                ('tag', models.CharField(db_index=True, max_length=255)),
                ('supertag', models.CharField(db_index=True, max_length=255)),
                ('title', models.CharField(default=b'', max_length=255)),
                (
                    'page_type',
                    models.CharField(
                        choices=[(b'G', 'pages.page:List'), (b'P', 'pages.page:Page')], default=b'P', max_length=1
                    ),
                ),
                ('lang', models.CharField(default=b'', max_length=2)),
                ('created_at', models.DateTimeField(default=wiki.utils.timezone.now)),
                ('is_official', models.BooleanField(default=False)),
                ('modified_at', models.DateTimeField()),
                (
                    'modified_at_for_index',
                    models.DateTimeField(db_index=True, default=datetime.datetime(1999, 12, 31, 21, 0, tzinfo=utc)),
                ),
                ('comments', models.PositiveIntegerField(default=0)),
                ('files', models.PositiveIntegerField(default=0)),
                ('is_blocking', models.BooleanField(default=False)),
                ('status', models.PositiveIntegerField(default=1)),
                ('opened_to_external_flag', models.NullBooleanField(default=None)),
                ('formatter_version', models.CharField(default=b'31.0', max_length=50, verbose_name=b'formatter')),
                (
                    'actuality_status',
                    models.PositiveIntegerField(
                        choices=[(-1, b'possibly_obsolete'), (0, b'unspecified'), (1, b'actual'), (2, b'obsolete')],
                        default=0,
                    ),
                ),
                (
                    'actuality_marked_at',
                    models.DateTimeField(
                        null=True,
                        verbose_name='\u043c\u043e\u043c\u0435\u043d\u0442 \u0441\u043c\u0435\u043d\u044b \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0430\u043a\u0442\u0443\u0430\u043b\u044c\u043d\u043e\u0441\u0442\u0438',
                    ),
                ),
                ('is_documentation', models.BooleanField(default=False)),
            ],
            options={
                'db_table': 'pages_page',
                'verbose_name': '\u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430',
                'verbose_name_plural': '\u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b',
            },
        ),
        migrations.CreateModel(
            name='Page2Staff',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name='PageLink',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
        ),
        migrations.CreateModel(
            name='PageRename',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('old_tag', models.CharField(db_index=True, max_length=255)),
                ('old_supertag', models.CharField(db_index=True, max_length=255)),
                ('new_tag', models.CharField(db_index=True, max_length=255)),
                ('new_supertag', models.CharField(db_index=True, max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name='PageWatch',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('user', models.CharField(db_index=True, max_length=80)),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('sent_at', models.DateTimeField(db_index=True, null=True)),
                ('is_cluster', models.BooleanField(default=False)),
            ],
        ),
        migrations.CreateModel(
            name='Referer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('referer', models.CharField(max_length=150)),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True)),
            ],
        ),
        migrations.CreateModel(
            name='Revision',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(default=b'', max_length=250)),
                ('created_at', models.DateTimeField(db_index=True)),
                (
                    'mds_storage_id',
                    models.FileField(
                        max_length=200,
                        null=True,
                        storage=django_mds.storage.MDSStorage(),
                        upload_to=wiki.pages.models.revision.upload_to,
                    ),
                ),
                ('formatter_version', models.CharField(default=b'1.0', max_length=50)),
            ],
        ),
    ]

    if settings.IS_INTRANET:
        operations.append(
            migrations.CreateModel(
                name='Officiality',
                fields=[
                    ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                    (
                        'created',
                        model_utils.fields.AutoCreatedField(
                            default=django.utils.timezone.now, editable=False, verbose_name='created'
                        ),
                    ),
                    (
                        'modified',
                        model_utils.fields.AutoLastModifiedField(
                            default=django.utils.timezone.now, editable=False, verbose_name='modified'
                        ),
                    ),
                ],
                options={
                    'verbose_name': '\u041e\u0444\u0438\u0446\u0438\u0430\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b',
                    'verbose_name_plural': '\u041e\u0444\u0438\u0446\u0438\u0430\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u0441\u0442\u0440\u0430\u043d\u0438\u0446',
                },
            )
        )
