# Generated by Django 1.9.8 on 2016-07-20 12:16
# flake8: noqa


from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('intranet', '0001_initial'),
        ('pages', '0001_initial'),
    ]

    operations = [
        migrations.AddField(
            model_name='revision',
            name='author',
            field=models.ForeignKey(
                related_name='revision_author_set',
                to=settings.AUTH_USER_MODEL,
                on_delete=models.CASCADE,
            ),
        ),
        migrations.AddField(
            model_name='revision',
            name='page',
            field=models.ForeignKey(to='pages.Page', on_delete=models.CASCADE),
        ),
        migrations.AddField(
            model_name='referer',
            name='page',
            field=models.ForeignKey(to='pages.Page', on_delete=models.CASCADE),
        ),
        migrations.AddField(
            model_name='pagewatch',
            name='page',
            field=models.ForeignKey(to='pages.Page', on_delete=models.CASCADE),
        ),
        migrations.AddField(
            model_name='pagerename',
            name='page',
            field=models.OneToOneField(to='pages.Page', on_delete=models.CASCADE),
        ),
        migrations.AddField(
            model_name='pagelink',
            name='from_page',
            field=models.ForeignKey(
                related_name='links_from', to='pages.Page', on_delete=models.CASCADE
            ),
        ),
        migrations.AddField(
            model_name='pagelink',
            name='to_page',
            field=models.ForeignKey(
                null=True, related_name='links_to', to='pages.Page', on_delete=models.CASCADE
            ),
        ),
        migrations.AddField(
            model_name='page2staff',
            name='page',
            field=models.ForeignKey(to='pages.Page', on_delete=models.CASCADE),
        ),
        migrations.AddField(
            model_name='page2staff',
            name='staff',
            field=models.ForeignKey(to='intranet.Staff', on_delete=models.CASCADE),
        ),
        migrations.AddField(
            model_name='page',
            name='last_author',
            field=models.ForeignKey(
                null=True,
                related_name='changed_pages',
                to=settings.AUTH_USER_MODEL,
                on_delete=models.CASCADE,
            ),
        ),
        migrations.AddField(
            model_name='page',
            name='owner',
            field=models.ForeignKey(
                null=True,
                related_name='pages',
                to=settings.AUTH_USER_MODEL,
                on_delete=models.CASCADE,
            ),
        ),
        migrations.AddField(
            model_name='page',
            name='redirects_to',
            field=models.ForeignKey(
                blank=True,
                default=None,
                null=True,
                related_name='redirected_from',
                to='pages.Page',
                on_delete=models.CASCADE,
            ),
        ),
        migrations.AddField(
            model_name='comment',
            name='page',
            field=models.ForeignKey(to='pages.Page', on_delete=models.CASCADE),
        ),
        migrations.AddField(
            model_name='comment',
            name='parent',
            field=models.ForeignKey(null=True, to='pages.Comment', on_delete=models.CASCADE),
        ),
        migrations.AddField(
            model_name='comment',
            name='user',
            field=models.ForeignKey(to=settings.AUTH_USER_MODEL, on_delete=models.CASCADE),
        ),
        migrations.AddField(
            model_name='actualitymarklink',
            name='actual_page',
            field=models.ForeignKey(
                related_name='actual_page',
                to='pages.Page',
                on_delete=models.CASCADE,
                verbose_name='\u0431\u043e\u043b\u0435\u0435 \u0430\u043a\u0442\u0443\u0430\u043b\u044c\u043d\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430',
            ),
        ),
        migrations.AddField(
            model_name='actualitymarklink',
            name='page',
            field=models.ForeignKey(
                related_name='page',
                to='pages.Page',
                on_delete=models.CASCADE,
                verbose_name='\u0443\u0441\u0442\u0430\u0440\u0435\u0432\u0448\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430',
            ),
        ),
        migrations.AddField(
            model_name='actualitymark',
            name='comment',
            field=models.OneToOneField(
                null=True,
                to='pages.Comment',
                on_delete=models.CASCADE,
                verbose_name='\u0441\u0441\u044b\u043b\u043a\u0430 \u043d\u0430 \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439',
            ),
        ),
        migrations.AddField(
            model_name='actualitymark',
            name='page',
            field=models.OneToOneField(
                to='pages.Page',
                on_delete=models.CASCADE,
                verbose_name='\u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430, \u043a \u043a\u043e\u0442\u043e\u0440\u043e\u0439 \u043e\u0442\u043d\u043e\u0441\u0438\u0442\u0441\u044f \u043e\u0442\u043c\u0435\u0442\u043a\u0430',
            ),
        ),
        migrations.AddField(
            model_name='actualitymark',
            name='user',
            field=models.ForeignKey(
                to=settings.AUTH_USER_MODEL,
                on_delete=models.CASCADE,
                verbose_name='\u043a\u0442\u043e \u0441\u043e\u0437\u0434\u0430\u043b',
            ),
        ),
        migrations.AddField(
            model_name='accessrequest',
            name='applicant',
            field=models.ForeignKey(
                related_name='applicant', to=settings.AUTH_USER_MODEL, on_delete=models.CASCADE
            ),
        ),
        migrations.AddField(
            model_name='accessrequest',
            name='page',
            field=models.ForeignKey(to='pages.Page', on_delete=models.CASCADE),
        ),
        migrations.AddField(
            model_name='accessrequest',
            name='verdict_by',
            field=models.ForeignKey(
                null=True,
                related_name='verdict_by',
                to=settings.AUTH_USER_MODEL,
                on_delete=models.CASCADE,
            ),
        ),
        migrations.AddField(
            model_name='access',
            name='page',
            field=models.ForeignKey(to='pages.Page', on_delete=models.CASCADE),
        ),
        migrations.AddField(
            model_name='access',
            name='staff',
            field=models.ForeignKey(null=True, to='intranet.Staff', on_delete=models.CASCADE),
        ),
        migrations.AddField(
            model_name='absentpage',
            name='from_page',
            field=models.ForeignKey(to='pages.Page', on_delete=models.CASCADE),
        ),
        migrations.AlterUniqueTogether(
            name='pagewatch',
            unique_together=set([('user', 'page')]),
        ),
        migrations.AlterUniqueTogether(
            name='pagelink',
            unique_together=set([('from_page', 'to_page')]),
        ),
        migrations.AlterUniqueTogether(
            name='actualitymarklink',
            unique_together=set([('page', 'actual_page')]),
        ),
        migrations.AlterUniqueTogether(
            name='absentpage',
            unique_together=set([('from_page', 'to_supertag')]),
        ),
    ]

    if settings.IS_INTRANET:
        operations.append(
            migrations.AddField(
                model_name='officiality',
                name='page',
                field=models.OneToOneField(to='pages.Page', on_delete=models.CASCADE),
            )
        )
        operations.append(
            migrations.AddField(
                model_name='officiality',
                name='responsible_persons',
                field=models.ManyToManyField(blank=True, to=settings.AUTH_USER_MODEL),
            )
        )
        operations.append(
            migrations.AddField(
                model_name='officiality',
                name='responsible_groups',
                field=models.ManyToManyField(blank=True, to='intranet.Group'),
            )
        )
        operations.append(
            migrations.AddField(
                model_name='access',
                name='group',
                field=models.ForeignKey(null=True, to='intranet.Group', on_delete=models.CASCADE),
            )
        )
    else:
        operations.append(
            migrations.AddField(
                model_name='access',
                name='group',
                field=models.ForeignKey(null=True, to='auth.Group', on_delete=models.CASCADE),
            )
        )
