# Generated by Django 1.9.9 on 2017-02-09 14:14


from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('connect', '0001_initial'),
        ('pages', '0003_auto_20160830_1937'),
    ]

    operations = [
        migrations.AddField(
            model_name='page',
            name='org',
            field=models.ForeignKey(
                blank=True,
                default=None,
                null=True,
                on_delete=models.CASCADE,
                to='connect.Organization',
            ),
        ),
        # У поля supertag в этой миграции снято unique=True,
        # makemigrations сгенерировал AlterField для этого
        # изменения, но миграция не захотела запускаться на
        # реальных базах по причине:
        #
        # django.db.utils.ProgrammingError: constraint "pages_page_supertag" of relation "pages_page" does not exist
        #
        # По идее при создании UNIQUE индекса должен создаваться
        # constraint, но в базах, мигрированных с MySQL,
        # constraint-ы для этих случаев не создались.
        #
        # Поэтому пришлось переписать AlterField на два SQL вызова ниже.
        migrations.RunSQL(
            'DROP INDEX IF EXISTS pages_page_supertag;',
            reverse_sql='CREATE INDEX pages_page_supertag ON pages_page USING btree (supertag);',
        ),
        migrations.RunSQL(
            'CREATE INDEX pages_page_supertag ON pages_page USING btree (supertag);',
            reverse_sql='DROP INDEX IF EXISTS pages_page_supertag;',
        ),
        migrations.AlterUniqueTogether(
            name='page',
            unique_together=set([('supertag', 'org')]),
        ),
    ]
