

from django.conf import settings
from django.db import migrations


class Migration(migrations.Migration):
    dependencies = [
        ('pages', '0004_add_org_to_page'),
    ]

    if settings.IS_BUSINESS:
        operations = []
    else:
        operations = [
            # Композитный unique (supertag, org) в не-B2B
            # инстансах не работает, т.к. org всегда равен None.
            # Поэтому для этих инстансов нужно вернуть unique полю supertag.
            migrations.RunSQL(
                'DROP INDEX IF EXISTS pages_page_supertag;',
                reverse_sql='CREATE INDEX pages_page_supertag ON pages_page USING btree (supertag);',
            ),
            migrations.RunSQL(
                'CREATE UNIQUE INDEX pages_page_supertag ON pages_page USING btree (supertag);',
                reverse_sql='DROP INDEX IF EXISTS pages_page_supertag;',
            ),
        ]
