# Generated by Django 1.9.9 on 2017-08-18 15:14


from django.conf import settings
from django.db import migrations, models
from django.db.models import Q


def set_is_autogenerated(apps, schema_editor):
    PageModel = apps.get_model('pages', 'Page')
    PageModel.objects.filter(
        Q(supertag__iregex='^users/([^/]+)$') | Q(supertag__iregex='^users/([^/]+)/notes$')
    ).update(is_autogenerated=True)

    if settings.IS_BUSINESS:
        PageModel.objects.filter(
            Q(supertag__istartswith='sandbox')
            | Q(supertag='homepage')
            | Q(supertag='users')
            | Q(supertag='clusterusers')
        ).update(is_autogenerated=True)


class Migration(migrations.Migration):

    dependencies = [
        ('pages', '0006_add_reference_page'),
    ]

    operations = [
        migrations.AddField(
            model_name='page',
            name='is_autogenerated',
            field=models.BooleanField(default=False),
        ),
        migrations.RunPython(set_is_autogenerated),
    ]
