

import enumfields.fields
import jsonfield.fields
from django.db import migrations, models

import wiki.integrations.consts


class Migration(migrations.Migration):
    dependencies = [
        ('pages', '0019_revision_mds_storage_id_index'),
    ]

    operations = [
        migrations.CreateModel(
            name='CloudPage',
            fields=[
                (
                    'page',
                    models.OneToOneField(
                        primary_key=True, serialize=False, to='pages.Page', on_delete=models.CASCADE
                    ),
                ),
                (
                    'provider',
                    enumfields.fields.EnumField(
                        default=b'ms365', enum=wiki.integrations.consts.CloudProviders, max_length=10
                    ),
                ),
                ('cloud_src', jsonfield.fields.JSONField(default=b'{}')),
                ('presentation_params', jsonfield.fields.JSONField(blank=True, null=True)),
            ],
        ),
        migrations.AlterField(
            model_name='page',
            name='formatter_version',
            field=models.CharField(default=b'41.0', max_length=50, verbose_name=b'formatter'),
        ),
        migrations.AlterField(
            model_name='page',
            name='page_type',
            field=models.CharField(
                choices=[(b'G', 'pages.page:List'), (b'P', 'pages.page:Page'), (b'C', 'pages.page' ':Cloud')],
                default=b'P',
                max_length=1,
            ),
        ),
    ]
