from django.db import models

from wiki.pages.models.page import Page


class AbsentPage(models.Model):
    objects: models.Manager

    from_page = models.ForeignKey(Page, on_delete=models.CASCADE)
    to_supertag = models.CharField(max_length=250, db_index=True)
    # Actually, I don't remember why we need this field
    to_tag = models.CharField(max_length=250, default='')

    def __str__(self):
        return 'Link from "%s" to nonexistent "%s"' % (self.from_page.supertag, self.to_supertag)

    class Meta:
        unique_together = (('from_page', 'to_supertag'),)
        app_label = 'pages'
