from django.conf import settings
from django.db import models

from wiki.pages.models.comment import Comment
from wiki.pages.models.page import Page


class ActualityMark(models.Model):
    """
    Модель отметки об актуальности страницы.
    """

    page = models.OneToOneField(Page, verbose_name='страница, к которой относится отметка', on_delete=models.CASCADE)
    user = models.ForeignKey(settings.AUTH_USER_MODEL, verbose_name='кто создал', on_delete=models.CASCADE)
    comment = models.OneToOneField(Comment, null=True, verbose_name='ссылка на комментарий', on_delete=models.CASCADE)

    class Meta:
        app_label = 'pages'

        verbose_name = 'отметка об актуальности страниц'
        verbose_name_plural = 'отметки об актуальности страниц'
