from django.db import models

from wiki.pages.models.page import Page


class ActualityMarkExternalLink(models.Model):
    page = models.ForeignKey(Page, verbose_name='устаревшая страница', on_delete=models.CASCADE)
    url = models.CharField(max_length=500, verbose_name='url для внешней ссылки')

    class Meta:
        unique_together = (('page', 'url'),)

        app_label = 'pages'

        verbose_name = 'внешняя ссылка для устаревшей страницы'
        verbose_name_plural = 'внешние ссылки для устаревшей страницы'
