from django.db import models

from wiki.pages.models.page import Page


class ActualityMarkLink(models.Model):
    """
    Модель ссылки на более актуальную вики-страницу.
    """

    page = models.ForeignKey(Page, related_name='page', verbose_name='устаревшая страница', on_delete=models.CASCADE)
    actual_page = models.ForeignKey(Page, related_name='actual_page', verbose_name='более актуальная страница', on_delete=models.CASCADE)

    class Meta:
        unique_together = (('page', 'actual_page'),)

        app_label = 'pages'

        verbose_name = 'ссылка на более актуальную страницу'
        verbose_name_plural = 'ссылки на более актуальные страницы'
