from django.db import models
from enumfields import EnumField
from jsonfield import JSONField

from wiki.integrations.consts import CloudProviders, Ms365AclManagementType
from wiki.integrations.ms.consts import SharepointCloudSrc
from wiki.pages.models.page import Page
from wiki.utils.timezone import now


class CloudPage(models.Model):
    objects: models.Manager

    page = models.OneToOneField(Page, primary_key=True, on_delete=models.CASCADE)
    provider = EnumField(CloudProviders, default=CloudProviders.MS365)
    acl_management = EnumField(Ms365AclManagementType, null=True)

    cloud_src = JSONField(default='{}')
    presentation_params = JSONField(blank=True, null=True)
    lastmodified_sync_at = models.DateTimeField(default=now)

    def get_cloud_src(self) -> SharepointCloudSrc:
        return SharepointCloudSrc.parse_obj(self.cloud_src)

    def __str__(self):
        return 'CloudPage %s: "%s"' % (self.page_id, self.page.supertag)
