from datetime import timedelta
from enum import Enum

from model_utils import Choices as LegacyChoices

from wiki.legacy.choices import Choices as LegacyChoices2

EDITED_PAGE_ACTUALITY_TIMEOUT = timedelta(days=365)
MARKED_PAGE_ACTUALITY_TIMEOUT = timedelta(days=365 / 2, hours=24 / 2)

DB_PAGE_TYPES = LegacyChoices2(
    PAGE=('P', 'article'),
    GRID=('G', 'grid'),
    CLOUD=('C', 'cloud'),
    WYSIWYG=('W', 'wikiwyg'),  # экспериментальный тип, где мы храним json-ки с контентом
)

ACTUALITY_STATUS = LegacyChoices(
    (-1, 'possibly_obsolete', 'possibly_obsolete'),
    (0, 'unspecified', 'unspecified'),
    (1, 'actual', 'actual'),
    (2, 'obsolete', 'obsolete'),
)

COMMENTS_STATUS = LegacyChoices(
    (0, 'enabled', 'enabled'),
    (1, 'disabled_on_page', 'disabled_on_page'),
    (2, 'disabled_on_cluster', 'disabled_on_cluster'),
)


class PageType(str, Enum):
    REGULAR_PAGE = 'page'
    GRID = 'grid'
    CLOUD_PAGE = 'cloud_page'
    WYSIWYG = 'wysiwyg'


DB_PAGE_TYPES_MAP = {
    'P': PageType.REGULAR_PAGE,
    'G': PageType.GRID,
    'C': PageType.CLOUD_PAGE,
    'W': PageType.WYSIWYG,
}

PAGE_TYPE_TO_DB_MAP = {
    PageType.REGULAR_PAGE: DB_PAGE_TYPES.PAGE,
    PageType.GRID: DB_PAGE_TYPES.GRID,
    PageType.CLOUD_PAGE: DB_PAGE_TYPES.CLOUD,
    PageType.WYSIWYG: DB_PAGE_TYPES.WYSIWYG,
}


class AclType(str, Enum):
    DEFAULT = 'default'
    ONLY_AUTHORS = 'only_authors'
    CUSTOM = 'custom'


ACL_TYPE_DESCRIPTION = """Значения:
- `default` - Доступ по-умолчанию. Для всех штатных сотрудников.
- `only_authors` - Только у авторов страницы
- `custom` - У определенных пользовтелей и групп
"""


class ActualityStatus(str, Enum):
    POSSIBLY_OBSOLETE = 'possibly_obsolete'
    UNSPECIFIED = 'unspecified'
    ACTUAL = 'actual'
    OBSOLETE = 'obsolete'


ACTUALITY_STATUS_MAP = {
    -1: ActualityStatus.POSSIBLY_OBSOLETE,
    0: ActualityStatus.UNSPECIFIED,
    1: ActualityStatus.ACTUAL,
    2: ActualityStatus.OBSOLETE,
}


class CommentStatusDb(int, Enum):
    ENABLED = 0
    DISABLED_ON_PAGE = 1
    DISABLED_ON_CLUSTER = 2
