from wiki.pages.models.page import Page
from wiki.pages.models.consts import ACTUALITY_STATUS, COMMENTS_STATUS
from wiki.sync.connect.base_organization import BaseOrganization
from wiki.utils import timezone
from wiki.utils.wiki_robot import get_wiki_robot


class CopyOnWritePage(Page):
    _is_cow = True

    comments_status = COMMENTS_STATUS.enabled
    files = 0
    is_official = False
    is_readonly = False
    lang = ''
    page_type = Page.TYPES.PAGE
    actuality_status = ACTUALITY_STATUS.actual
    redirects_to = None
    with_new_wf = True
    background_id = None

    def __init__(self, id: int, supertag: str, organization: BaseOrganization, title: str = '', body: str = ''):
        self._wiki_robot = get_wiki_robot(organization=organization)
        self._org = organization.as_django_model()
        self.id = id
        self.supertag = self.tag = supertag
        self.title = title if title else supertag
        self._body = body

        created = self.org.created if self.org else timezone.now()
        self.created_at = self.modified_at = self.modified_at_for_index = created

    @property
    def body(self):
        return self._body

    @property
    def org(self):
        return self._org

    def authors(self):
        return self.get_authors()

    def get_authors(self):
        return [self._wiki_robot]

    def get_page_version(self):
        return '0'

    @property
    def owner(self):
        return self._wiki_robot

    @property
    def last_author(self):
        return self._wiki_robot

    @property
    def comments_count(self):
        return 0

    @property
    def officiality(self):
        return None

    @property
    def realtime_actuality_status(self):
        return ACTUALITY_STATUS.actual

    def get_keywords(self):
        return []

    def set_keywords(self, value):
        pass

    keywords_list = property(get_keywords, set_keywords, doc='access to old PHP keywords')

    def __copy__(self):
        page = Page(self)
        page.title = self.title
        # Явно выставляем body, чтобы сохранить его в mds
        page.body = self._body
        return page

    def __hash__(self):
        return hash(self.supertag)

    def save(self):
        pass

    class Meta:
        proxy = True
        app_label = 'pages'
