from django.db import models

from wiki.pages.models.page import Page


class LocationHistory(models.Model):
    """
    Модель для сохранения бывших адресов страниц
    """

    id: models.IntegerField
    objects: models.Manager

    # бывший адрес страницы
    slug = models.CharField(max_length=255, db_index=True)

    page = models.ForeignKey(Page, on_delete=models.CASCADE)

    def __str__(self):
        return f'LocationHistory {self.id} of slug "{self.slug}" and page "{self.page.slug}"'  # noqa

    class Meta:
        app_label = 'pages'
        constraints = [models.UniqueConstraint(fields=['slug', 'page'], name='location_history_unique_slug_page')]
