
from django.core import validators
from django.db import models


class CutByMaxLengthCharField(models.CharField):
    """
    Поле, которое без предупреждения обрезает длину текста, которое в него сохраняют.
    """

    def __init__(self, *args, **kwargs):
        super(CutByMaxLengthCharField, self).__init__(*args, **kwargs)

        # remove MaxLengthValidator
        for index, validator in enumerate(self.validators):
            if isinstance(validator, validators.MaxLengthValidator):
                self.validators.pop(index)
                break

    @staticmethod
    def strip_text(value, max_length):
        return value[:max_length]

    def clean(self, value, model_instance):
        value = super(CutByMaxLengthCharField, self).clean(value, model_instance)
        return self.strip_text(value, self.max_length)
