
from django.db import models
from django.conf import settings


class Notification(models.Model):
    """
    Новостное/информационное сообщение, показываемое пользователю в шапке страницы.
    """

    # текст сообщения
    message = models.CharField(max_length=1000)

    # ссылка под текстом сообщения
    url = models.CharField(max_length=255)

    # признак актуальности сообщения на уровне приложения.
    # Если отключен, то сообщение не будет показываться никому ни при каких условиях.
    is_active = models.BooleanField(default=False)

    # признак актуальности сообщения на уровне пользователя.
    # Если пользователь есть в этом списке - значит сообщение показывать ему уже не надо.
    disabled_for_users = models.ManyToManyField(
        settings.AUTH_USER_MODEL,
        blank=True,
    )
