
from django.conf import settings
from django.db import models
from model_utils.models import TimeStampedModel


class Officiality(TimeStampedModel):
    """
    Данные про официальность страницы.
    """

    page = models.OneToOneField(
        to='pages.Page',
        on_delete=models.CASCADE,
    )
    responsible_persons = models.ManyToManyField(
        to=settings.AUTH_USER_MODEL,
        blank=True,
    )
    responsible_groups = models.ManyToManyField(
        to='intranet.Group',
        blank=True,
    )

    class Meta:
        app_label = 'pages'

        verbose_name = 'Официальность страницы'
        verbose_name_plural = 'Официальность страниц'

    def __str__(self):
        return self.page.supertag
