
from django.db import models

from wiki.pages.models.page import Page


class PageLink(models.Model):
    from_page = models.ForeignKey(Page, related_name='links_from', on_delete=models.CASCADE)
    to_page = models.ForeignKey(Page, null=True, related_name='links_to', on_delete=models.CASCADE)

    def __str__(self):
        return 'Link from "%s" to "%s"' % (self.from_page.supertag, self.to_page.supertag)

    class Meta:
        unique_together = (('from_page', 'to_page'),)
        app_label = 'pages'
