from django.db import models

from wiki.pages.models.page import Page


class PageWatch(models.Model):
    """
    Подписавшиеся на страницу пользователи
    """

    id: int
    objects: models.Manager

    user = models.CharField(max_length=80, db_index=True)
    page = models.ForeignKey(Page, on_delete=models.CASCADE)
    created_at = models.DateTimeField(db_index=True, auto_now_add=True)
    sent_at = models.DateTimeField(db_index=True, null=True)
    is_cluster = models.BooleanField(default=False)

    def __str__(self):
        return '"{user}" is subscribed to "{page}"'.format(page=self.page, user=self.user)

    class Meta:
        unique_together = (('user', 'page'),)
        app_label = 'pages'
