
from django.db import models

from wiki.pages.models.page import Page


class Redirect(models.Model):
    page = models.OneToOneField(Page, on_delete=models.CASCADE)
    to = models.ForeignKey(Page, related_name='to', on_delete=models.CASCADE)
    anchor = models.CharField(max_length=255)

    def __str__(self):
        page = self.page.supertag if self.page else ''
        to = self.to.supertag if self.to else ''
        return "\"%s\" -> \"%s\"" % (page, to)

    class Meta:
        app_label = 'pages'
